<?php
/**
 * MSSQL Test
 *
 * Tests PHP's ability to connect to MSSQL databases.
 *
 * @author     David Cassidy <david.cassidy@hostek.com>
 * @copyright  2024 Hostek
 * @license    https://unlicense.org/ Unlicense
 */

// Initialize settings
// Note: These credentials only get you read-only access to an empty database
$svrHostname = '62.3.5.76'; // sql1-p4.ezhostingserver.com
$svrPort     = '1433';
$svrDatabase = 'ht_phptest';
$svrUsername = 'ht_phptest';
$svrPassword = '?dh%0QHA*FUtTj2R';

try {
    // Initialize connection
    sqlsrv_configure('WarningsReturnAsErrors',0);
    $conn = sqlsrv_connect(
        "${svrHostname}, ${svrPort}",
        [
            'Database' => $svrDatabase,
            'UID'      => $svrUsername,
            'PWD'      => $svrPassword,
        ]
    );

    if (!$conn) {
        throw new Exception(
            'An error occurred while trying to connect to the database:<br />'
            . '<pre>' . print_r(sqlsrv_errors(), true) . '</pre>'
        );
    } else {
        // Initialize query
        $sql = "SELECT * FROM dbo.options";

        // Run query
        $result = sqlsrv_query($conn, $sql);

        // Check results
        if ($result === false) {
            throw new Exception(
                'An error occurred while trying to query the database:<br />'
                . '<pre>' . print_r(sqlsrv_errors(), true) . '</pre>'
            );
        }
        while ($row = sqlsrv_fetch_array($result)) {
            echo '<p>' . $row['message'] . '</p>';
        }

        // Free memory
        sqlsrv_free_stmt($result);

        // Close connection
        sqlsrv_close($conn);
    }
} catch (Exception $e) {
    echo $e->getMessage();
}
