$targetKey = "HKLM:\SOFTWARE\Wow6432Node\Microsoft\VisualStudio\14.0\VC\Runtimes\x64"
$redistLink = "https://aka.ms/vs/17/release/vc_redist.x64.exe"
$tempC = "C:\temp\"
$tempD = "D:\temp\"
$redist = "vc_redist.x64.exe"
$found = 0

if (Test-Path $targetKey) {
    $result = Get-ItemProperty -Path $targetKey
    if ($result.Installed -eq 1) {
        $major = $result.Major
        $minor = $result.Minor
        if ($major -eq 14 -and $minor -ge 29) {
            $found = 1
        }
    }
}

if ($found -eq 0) {
    $temp = $tempC

    if (-not (Test-Path -Path $temp)) {
        $temp = $tempD
    }

    $temp += $redist

    try {
        if (-not (Test-Path -Path $temp)) {
            [Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
            Invoke-WebRequest $redistLink -OutFile $temp
        }

        if (Test-Path -Path $temp) {
            Start-Process -Wait -FilePath $temp -ArgumentList "/S" -PassThru
            Remove-Item $temp;
        }
    } catch {
        Write-Host $_
    }
}
